<?php

namespace DefStudio\GameEngine\Listeners\Users;

use Illuminate\Support\Facades\Mail;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Mail\User\WelcomeEmail;
use DefStudio\GameEngine\Events\Users\UserCreated;

class SendWelcomeEmail
{
    public function handle(UserCreated $event): void
    {
        if (!Feature::welcome_email->enabled()) {
            return;
        }

        Mail::to($event->user)->send(new WelcomeEmail($event->user, $event->password));
    }
}
