<?php

use DefStudio\GameEngine\Enums\Role;

?>


@props(['run'])

@php($user = game_engine()->user())

<x-card :padding="false">
    <x-slot name="header">
        {{$run->story->title}}
    </x-slot>

    @if($cover_url = $run->story->getFirstMediaUrl(\DefStudio\GameEngine\Enums\MediaCollection::cover, \DefStudio\GameEngine\Enums\MediaConversion::square))
        <img class="w-full" src="{{$cover_url}}">
    @endif

    <x-slot name="actions">
        @if($run->completed_at !== null)
            {{__('Completed')}}
        @elseif($run->started_at !== null)
            <x-link href="{{route('game-engine.run', $run)}}">{{__('Continue')}}</x-link>
        @else
            <x-link href="{{route('game-engine.run', $run)}}">{{__('Play')}}</x-link>
        @endif
    </x-slot>
</x-card>
