@php
    use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
    use DefStudio\GameEngine\Enums\MediaCollection;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMission;
    use DefStudio\GameEngine\Enums\StorytellingType;

    /** @var Runner $this */
@endphp

<x-game-engine::runs.map.box>
    <!--suppress JSUnresolvedReference -->
    <script>

        if (window.Alpine === undefined) {
            document.addEventListener('alpine:init', init_alpine_map);
        } else {
            init_alpine_map();
        }

        function init_alpine_map() {
            Alpine.data('map', () => ({
                missions: [],
                current_mission_index: 0,
                size: {w: 0, h: 0},
                zoom: 1,
                ready: false,

                init() {
                    this.$nextTick(() => {
                        this.size.w = this.$refs.background.naturalWidth;
                        this.size.h = this.$refs.background.naturalHeight;
                        this.update_zoom();
                        this.update_missions();
                    });

                    this.$wire.on('mission:activated', () => {
                        this.update_missions()
                    });
                },
                update_missions() {
                    this.$wire.call('current_mission_index').then(index => this.current_mission_index = index);

                    this.$wire.call('get_missions').then(missions => {
                        this.missions = missions;
                        console.log(this.missions);
                        this.ready = true;
                    });
                },
                update_zoom() {
                    const screen_w = document.documentElement.clientWidth;
                    const screen_h = document.documentElement.clientHeight;

                    if (screen_w >= this.size.w && screen_h >= this.size.h) {
                        this.zoom = 1;
                        return;
                    }

                    const zoom_w = screen_w / this.size.w;
                    const zoom_h = screen_h / this.size.h;

                    this.zoom = Math.min(zoom_w, zoom_h);
                },
                is_active(mission_index) {
                    return +this.current_mission_index === +mission_index;
                },
                open_mission(mission_index) {
                    if (!this.is_active(mission_index)) {
                        return;
                    }

                    this.$wire.call('start_mission', mission_index);
                }
            }));
        }

    </script>

    <div x-data="map" class="relative" :style="{zoom: zoom}" @resize.window="update_zoom" x-show="ready" x-cloak>
        <div :style="{width: size.w+'px', height: size.h+'px'}">
            <img src="{{$this->map->getFirstMediaUrl(MediaCollection::background)}}" x-ref="background">
        </div>

        <template x-for="(mission, mission_index) in missions" :key="mission.id">
            <img class="absolute"
                 :class="{'cursor-pointer': is_active(mission_index)}"
                 :style="{top: mission.pos_y+'px', left: mission.pos_x+'px'}"
                 :src="mission.placeholder_image"
                 x-show="mission.visible"
                 @click="open_mission(mission_index)"
            >
        </template>
    </div>


</x-game-engine::runs.map.box>
