<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Awards;

use DefStudio\Actions\Action;
use Illuminate\Http\Testing\File;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Award;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Awards\AwardIconImageUpdated;

/**
 * @method static void run(Award $award, UploadedFile $icon_image_file)
 */
class StoreIconImage extends Action
{
    public function handle(Award $award, UploadedFile $icon_image_file): void
    {
        Gate::authorize('update', $award);

        $award->addMedia($icon_image_file)
            ->toMediaCollection(MediaCollection::icon->name);

        AwardIconImageUpdated::dispatch($award);
    }
}
