<?php

namespace DefStudio\GameEngine\Actions\Missions\Extractor;

use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\Mission;

class DefaultTaskExtractor implements Contracts\TaskExtractor
{
    /**
     * {@inheritDoc}
     */
    public function extract(Run $run, Mission $mission): Collection
    {
        return $mission->tasks
            ->when(
                $mission->should_randomize_tasks_order(),
                fn(Collection $tasks) => $tasks->shuffle()
            )->when(
                $mission->max_tasks_to_show(),
                fn(Collection $tasks, int $max) => $tasks->take($max)
            );
    }
}
