<?php

namespace DefStudio\GameEngine\Actions\Users;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\User;

/**
 * @method static void run(User $user)
 */
class DeleteUser extends Action
{
    public function handle(User $user): void
    {
        Gate::authorize('delete', $user);

        $user->deleteProfilePhoto();
        $user->tokens->each->delete();
        $user->delete();
    }
}
