<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Enums;

use DefStudio\GameEngine\Exceptions\FeatureException;

enum Feature
{
    case impersonate;
    case welcome_email;
    case storytelling;
    case awards_hierarchy;
    case scoped_awards;

    public function enabled(): bool
    {
        return in_array($this, config('game-engine.features', []));
    }

    public function enforce(): void
    {
        throw_if(!$this->enabled(), FeatureException::not_enabled($this));
    }

    public function disabled(): bool
    {
        return !$this->enabled();
    }
}
