<?php

namespace DefStudio\GameEngine;

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Database\Eloquent\Model;
use Spatie\LaravelPackageTools\Package;
use DefStudio\GameEngine\Views\Components\Editor;
use DefStudio\GameEngine\Middleware\SetUserLocale;
use DefStudio\GameEngine\Commands\SyncRolesCommand;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use DefStudio\GameEngine\Commands\MakeSuperAdminCommand;

class GameEngineServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('game-engine')
            ->hasConfigFile()
            ->hasAssets()
            ->hasViews()
            ->hasViewComponent('', Editor::class)
            ->hasMigrations([
                'add_locale_to_users',
                'create_organizations_table',
                'create_organization_user_table',
                'add_current_organization_id_to_users',
                'create_teams_table',
                'create_team_user_table',
                'create_stories_table',
                'create_story_team_table',
                'create_maps_table',
                'create_media_table',
                'create_missions_table',
                'create_tasks_table',
                'create_storytellings_table',
                'create_awards_table',
                'create_runs_table',
            ])
            ->hasRoutes('web')
            ->hasCommand(SyncRolesCommand::class)
            ->hasCommand(MakeSuperAdminCommand::class);
    }

    public function packageRegistered(): void
    {
        $kernel = $this->app->make(Kernel::class);
        $kernel->pushMiddleware(SetUserLocale::class);
    }

    public function packageBooted(): void
    {
        Model::preventLazyLoading(!$this->app->isProduction());
    }
}
