<?php

namespace DefStudio\GameEngine\Http\Livewire\Runs\Concerns;

use DefStudio\GameEngine\Enums\StorytellingType;
use DefStudio\GameEngine\Decorators\ModelDecorator;
use DefStudio\GameEngine\Models\Contracts\WithStorytelling;

trait RunsStory
{
    public function mountRunsStory(): void
    {
        $this->setup_storytellings($this->run->story);
    }

    protected function complete_storytelling_runs_story(string|ModelDecorator|WithStorytelling $scope, StorytellingType|string $type): void
    {
        $type = StorytellingType::build_from($type);
        $scope = $this->get_storytelling_scope($scope);

        if ($scope !== 'story') {
            return;
        }

        if ($type === StorytellingType::activation && !$this->show_storytelling($scope, StorytellingType::prologue)) {
            $this->next_map();

            return;
        }

        if ($type === StorytellingType::prologue) {
            $this->next_map();

            return;
        }

        if ($type === StorytellingType::epilogue) {
            $this->complete_story();
        }
    }

    public function start(): void
    {
        if ($this->is_map_active()) {
            $this->call_traits_method('start');

            return;
        }

        if ($this->show_storytelling($this->run->story, StorytellingType::activation, StorytellingType::prologue)) {
            return;
        }

        $this->next_map();
    }

    protected function complete_story(): void
    {
        if ($this->show_storytelling($this->run->story, StorytellingType::prologue)) {
            return;
        }

        // TODO procedura di completamento storia
    }
}
