<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Listeners\Missions;

use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Actions\Tasks\DeleteTask;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;
use DefStudio\GameEngine\Events\Missions\DeletingMission;

class DeletingMissionListener
{
    public function handle(DeletingMission $event): void
    {
        $event->mission->loadMissing('tasks');
        $event->mission->tasks->each(fn(Task|TaskDecorator $task) => DeleteTask::run($task));
    }
}
