<?php

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories\Concerns;

use DefStudio\GameEngine\Enums\StorytellingType;
use DefStudio\GameEngine\Database\Factories\StorytellingFactory;

trait HasStorytelling
{
    public function with_storytelling(StorytellingType $storytelling_type, bool $with_media = false, array|string $text = null, string $background_path = null, string $avatar_path = null): self
    {
        if ($text && is_string($text)) {
            $text = [
                'en' => $text,
            ];
        }

        return $this->has(game_engine()->storytellingClass()::factory(['type' => $storytelling_type])
            ->when($text, fn(StorytellingFactory $factory) => $factory->state(['text' => $text]))
            ->when($with_media === true, fn(StorytellingFactory $factory) => $factory->with_background_image()->with_avatar_image())
            ->when($background_path, fn(StorytellingFactory $factory) => $factory->with_background_image($background_path))
            ->when($avatar_path, fn(StorytellingFactory $factory) => $factory->with_avatar_image($avatar_path))
        );
    }

    public function with_prologue(bool $with_media = false, array|string $text = null, string $background_path = null, string $avatar_path = null): self
    {
        return $this->with_storytelling(StorytellingType::prologue, $with_media, $text, $background_path, $avatar_path);
    }

    public function with_activation_storytelling(bool $with_media = false, array|string $text = null, string $background_path = null, string $avatar_path = null): self
    {
        return $this->with_storytelling(StorytellingType::activation, $with_media, $text, $background_path, $avatar_path);
    }

    public function with_epilogue(bool $with_media = false, array|string $text = null, string $background_path = null, string $avatar_path = null): self
    {
        return $this->with_storytelling(StorytellingType::epilogue, $with_media, $text, $background_path, $avatar_path);
    }
}
