<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Tasks;

use DefStudio\Actions\Action;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Enums\MediaCollection;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;

/**
 * @method static Media run(Task|TaskDecorator $task, UploadedFile $asset_image_file, MediaCollection|string $collection_name = null)
 */
class StoreAssetImage extends Action
{
    public function handle(Task|TaskDecorator $task, UploadedFile $asset_image_file, MediaCollection|string $collection_name = null): Media
    {
        $real_task = $task instanceof TaskDecorator ? $task->model() : $task;

        Gate::authorize('update', $real_task);

        if ($collection_name instanceof MediaCollection) {
            $collection_name = $collection_name->name;
        }

        return $real_task->addMedia($asset_image_file)
            ->toMediaCollection($collection_name ?? MediaCollection::assets->name);
    }
}
