<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use Carbon\Carbon;
use DefStudio\GameEngine\Enums\MediaCollection;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Database\Factories\Concerns\DefinesAwards;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;

class StoryFactory extends Factory
{
    use HasStorytelling;
    use DefinesAwards;
    use HasMedia;

    public function modelName(): string
    {
        return \game_engine()->storyClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence(),
            'description' => fake()->text,
            'organization_id' => game_engine()->organizationClass()::factory(),
            'published_at' => '2023-01-01 00:00:00',
        ];
    }

    public function with_cover_image(string $path = null): StoryFactory
    {
        return $this->with_media(MediaCollection::cover, $path);
    }

    public function published(Carbon $when = null): StoryFactory
    {
        return $this->state([
            'published_at' => $when ?? carbon('2023-01-01'),
        ]);
    }
}
