@php
    use DefStudio\GameEngine\Enums\Permission;
    use DefStudio\GameEngine\Enums\Role;
    /** @var \DefStudio\GameEngine\Models\Organization $organization */
@endphp
<x-card>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <div>
            <x-text model="organization.name" size="sm" defer :label="__('Name')"/>
        </div>
    </div>


    <x-slot name="actions">
        @can('create', Role::admin)
            <x-button color="secondary"
                      class="mr-auto"
                      wire:click="$emit('openModal', 'game-engine.admin.users.edit', {{json_encode(['isModal' => true, 'creating_role' => Role::admin->value])}})"
                      @click="$wire.set('role_under_creation', '{{Role::admin->value}}')"
            >{{__('Add Admin')}}</x-button>
        @endcan

        @can('create', Role::master)
            <x-button color="secondary"
                      class="mr-auto"
                      wire:click="$emit('openModal', 'game-engine.admin.users.edit', {{json_encode(['isModal' => true, 'creating_role' => Role::master->value)}})"
                      @click="$wire.set('role_under_creation', '{{Role::master->value}}')"
            >{{__('Add Master')}}</x-button>
        @endcan

        @can('create', Role::player)
            <x-button color="secondary"
                      class="mr-auto"
                      wire:click="$emit('openModal', 'game-engine.admin.users.edit', {{json_encode(['isModal' => true, 'creating_role' => Role::player->value)}})"
                      @click="$wire.set('role_under_creation', '{{Role::player->value}}')"
            >{{__('Add Player')}}</x-button>
        @endcan

        <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
    </x-slot>
</x-card>
