@props(['id', 'model', 'label', 'setup_data', 'locales'])


<div x-data="{active_lang: '{{array_key_first($locales)}}' }" {{$attributes}}>

    @if(count($locales) > 1)
        <div class="mb-1 border-b border-gray-200">
            <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" role="tablist">
                @if(!empty($label))
                    <div class="pr-2 py-1 text-gray-700">
                        {{$label}}:
                    </div>
                @endif
                @foreach($locales as $locale_key => $locale_label)
                    <li class="mr-2" role="presentation">
                        <button class="inline-block px-2 py-1 border-b-2 rounded-t-lg"
                                :class="{
                                    'text-gray-700 border-gray-400': active_lang == '{{$locale_key}}',
                                    'text-gray-400 border-transparent': active_lang != '{{$locale_key}}',
                                }"
                                @click="active_lang='{{$locale_key}}'"
                                type="button" role="tab">
                            {{$locale_label}}
                        </button>
                    </li>
                @endforeach
            </ul>
        </div>
    @endif
    @foreach($locales as $locale_key => $locale_label)
        <div x-show="active_lang == '{{$locale_key}}'">
            <x-editor id="{{$id}}-{{$locale_key}}" model="{{$model}}.{{$locale_key}}" :label="count($locales) === 1 ? $label : null">
                @php
                    $text = $setup_data[$locale_key] ?? '';

                    if(empty($text)){
                        $text = $setup_data[array_key_first($locales)] ?? '';
                    }
                @endphp

                {{$text}}
            </x-editor>
        </div>
    @endforeach
</div>


