<?php

/** @noinspection PhpMissingFieldTypeInspection */

namespace DefStudio\GameEngine\Decorators\Tasks;

use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Http\Livewire\Tasks\Edit;
use DefStudio\GameEngine\Decorators\ModelDecorator;

/**
 * @extends ModelDecorator<Task>
 *
 * @mixin Task
 */
abstract class TaskDecorator extends ModelDecorator
{
    protected array $media_collections = [];

    abstract public static function type_label(): string;

    abstract public static function configuration_component(): string;

    protected function setup_decorator(): void
    {
        collect($this->media_collections)->each(fn(MediaCollection $collection) => $this->model->enable_media_collection($collection));
    }

    public function saving_from_livewire_editor(Edit $edit): void
    {
        //..
    }

    abstract public static function run_component(): string;

    abstract public function is_complete(array $state): bool;

    abstract public function process_completion(array $state): array;
}
