<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use DefStudio\GameEngine\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class UsersController
{
    use AuthorizesRequests;

    public function index()
    {
        $this->authorize('viewAny', game_engine()->userClass());

        return view('game-engine::admin.users.index');
    }

    public function create()
    {
        $this->authorize('create', app(User::class));

        return view('game-engine::admin.users.edit');
    }

    public function edit(int $user)
    {
        $user = \game_engine()->userQuery()->findOrFail($user);
        $this->authorize('update', $user);

        return view('game-engine::admin.users.edit', ['user' => $user]);
    }
}
