<?php

namespace DefStudio\GameEngine\Middleware;

use Closure;
use Illuminate\Http\Request;
use DefStudio\GameEngine\Enums\Role;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        /** @phpstan-ignore-next-line  */
        abort_if(!Auth::user()?->hasAnyRole(Role::admin->name, Role::super_admin->name), 403);

        return $next($request);
    }
}
