<?php

/** @noinspection PhpUnhandledExceptionInspection */

use DefStudio\GameEngine\GameEngine;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Exceptions\LocalizationException;

if (!function_exists('game_engine')) {
    function game_engine(): GameEngine
    {
        return app(GameEngine::class);
    }
}

if (!function_exists('localize')) {
    function localize(array|ArrayObject $localized_array): string
    {
        if (Feature::multi_language->disabled()) {
            return $localized_array[config('app.locale')] ?? $localized_array[config('app.fallback_locale')] ?? throw LocalizationException::missing_translation(config('app.locale'));
        }

        return $localized_array[game_engine()->user()->locale] ?? $localized_array[config('app.fallback_locale')] ?? throw LocalizationException::missing_translation(game_engine()->user()->locale);
    }
}
