<div>
    <div class="mt-3 space-y-1">
        @if(game_engine()->user()->current_organization)
            <div class="block w-full pl-3 pr-4 py-2 border-l-4 border-transparent text-left text-base font-bold text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 focus:outline-none focus:text-gray-800 focus:bg-gray-50 focus:border-gray-300 transition duration-150 ease-in-out">
                Current Organization: {{game_engine()->user()->current_organization->name}}
            </div>
        @endif

        @foreach(game_engine()->visibleOrganizationQuery()->get() as $organization)
            @continue($organization->id === game_engine()->user()->current_organization_id)
            <a class="block w-full pl-5 pr-4 py-2 border-l-4 border-transparent text-left text-base font-medium text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 focus:outline-none focus:text-gray-800 focus:bg-gray-50 focus:border-gray-300 transition duration-150 ease-in-out"
               href="{{route('game-engine.organizations.switch', $organization)}}"
            >
                Switch to {{ $organization->name }}
            </a>
        @endforeach
    </div>
</div>
