<?php /** @var \DefStudio\GameEngine\Models\User $model */ ?>

<div class="flex">
    @can('update', $model)
        <x-link icon="pencil" color="secondary" size="sm" :href="route('game-engine.admin.users.edit', $model)"/>
    @endcan
    @can('impersonate', $model)
            <x-link class="ml-2" icon="eye" color="secondary" size="sm" :href="$model->get_impersonate_url('/')">{{__('Impersonate')}}</x-link>
    @endcan
    @can('delete', $model)
        <x-confirm-action class="ml-auto" title="Warning"
                          :content="__('Do you really want to delete this user?')"
                          :requires-password="true"
                          wire:then="delete({{$model->id}})"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
