<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;

class StoryException extends Exception
{
    public static function already_subscribed(): StoryException
    {
        return new self('Cannot subscribe a team twice to a story');
    }

    public static function team_subscription_failure(): StoryException
    {
        return new self('Team is not subscribed to story');
    }

    public static function organization_membership_failure(): StoryException
    {
        return new self("Story does not belongs to this team's organization");
    }
}
