<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Models\Organization;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class TeamsController
{
    use AuthorizesRequests;

    public function index(): View
    {
        $organization = \game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);

        $this->authorize('viewAny', \game_engine()->teamClass());

        return view('game-engine::admin.teams.index', ['organization' => $organization]);
    }

    public function create(): View
    {
        $organization = \game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);

        $this->authorize('create', \game_engine()->teamClass());

        return view('game-engine::admin.teams.edit', ['organization' => $organization]);
    }

    public function edit(int $team): View
    {
        /** @var Organization $organization */
        $organization = \game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);
        $team = $organization->teams()->findOrFail($team);

        $this->authorize('update', $team);

        return view('game-engine::admin.teams.edit', ['organization' => $organization, 'team' => $team]);
    }
}
