<?php

namespace DefStudio\GameEngine\Policies;

use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class RunPolicy
{
    use HandlesAuthorization;

    public function play(User $user, Run $target): bool
    {
        if (!app(StoryPolicy::class)->play($user, $target->story)) {
            return false;
        }

        return $target->user_id === $user->id;
    }
}
