@props(['scope' => null, 'parent' => null, 'label' => __('Available Awards')])
@php
    use DefStudio\GameEngine\Enums\Feature;
    /** @var \Illuminate\Database\Eloquent\Model|null $scope */
    /** @var \DefStudio\GameEngine\Models\Award|null $parent */

    if($parent !== null)
    {
        $scope = $parent->scope;
    }

    $should_show = match (true){
        $scope === null,
        Feature::awards_hierarchy->enabled() && $parent,
        Feature::scoped_awards->enabled() && game_engine()->available_award_scopes()->contains($scope::class) => true,
        default => false,
    };
@endphp
@if($should_show)
    <x-card :collapsed="$scope !== null">
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            <x-icon name="star"/>&nbsp;{{$label}}
        </x-slot>

        <livewire:game-engine.admin.awards.award-list :scope="$scope" :parent="$parent"/>
    </x-card>
@endif
