@php
    use DefStudio\GameEngine\Enums\MediaCollection
    /** @var \DefStudio\GameEngine\Http\Livewire\Missions\Edit $this */
@endphp


@php($background_url = $this->storytelling->getFirstMediaUrl(MediaCollection::background))
@php($avatar_url = $this->storytelling->getFirstMediaUrl(MediaCollection::avatar))
<x-card :collapsed="!empty($background_url) && !empty($avatar_url)">
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
       <x-icon name="photo"/>&nbsp;{{__('Images')}}
    </x-slot>

    <div class="grid grid-cols-1 gap-6">
        <x-game-engine::livewire.image_field
            id="background_image"
            model="background_image"
            :uploaded-url="$background_url"
            remove-method="remove_background"
            :label="__('Background Image')"
            :helper="__('SVG, PNG or JPG')"
        />

        <x-game-engine::livewire.image_field
            id="avatar"
            model="avatar"
            :uploaded-url="$avatar_url"
            remove-method="remove_avatar"
            :label="__('Avatar')"
            :helper="__('SVG, PNG or JPG')"
        />
    </div>
</x-card>
