<?php

namespace DefStudio\GameEngine\Decorators\Runs;

use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Decorators\ModelDecorator;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;

/**
 * @extends ModelDecorator<TaskDecorator>
 *
 * @mixin TaskDecorator
 */
class PlayableTask extends ModelDecorator
{
    private Run $run;

    protected function setup_decorator(): void
    {
        $this->model->loadMissing(['media', 'storytellings']);
    }

    public function setup(Run $run): self
    {
        $this->run = $run;

        return $this;
    }

    public function completed(): bool
    {
        return $this->model->is_complete($this->run->get_state("tasks.$this->id.result", []));
    }
}
