<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Livewire\Organizations;

use DefStudio\WiredTables\WiredTable;
use Illuminate\Database\Eloquent\Builder;
use DefStudio\GameEngine\Models\Organization;
use Illuminate\Database\Eloquent\Relations\Relation;
use DefStudio\GameEngine\Actions\Organizations\DeleteOrganization;

class Table extends WiredTable
{
    protected function query(): Builder|Relation
    {
        $query = game_engine()->visibleOrganizationQuery();

        return $query->withCount(['admins', 'masters', 'players', 'teams']);
    }

    protected function columns(): void
    {
        $this->column(__('Name'), 'name')->searchable()->sortable();
        $this->column(__('Admins'), 'admins_count');
        $this->column(__('Players'), 'players_count');
        $this->column(__('Masters'), 'masters_count');
        $this->column(__('Teams'), 'teams_count');
        $this->column(__('Actions'))->view('game-engine::livewire.admin.organizations.table.actions');
    }

    public function delete(Organization $organization): void
    {
        DeleteOrganization::run($organization);
    }
}
