@php

    use DefStudio\GameEngine\Http\Livewire\Tasks\Edit;
    use DefStudio\GameEngine\Actions\Awards\GetAwardsForScope;
    use DefStudio\GameEngine\Enums\MediaConversion;

    /** @var Edit $this */

    /** @var \DefStudio\GameEngine\Decorators\Tasks\DragAndDrop $task */
    $task = $this->task;

    $available_awards = GetAwardsForScope::run($task->model);

    $task->loadMissing('media.model');
@endphp
<div class="flex flex-col  gap-6">
    <div class="flex flex-col gap-6">
        <x-game-engine::elements.localized-editor
            id="question_editor"
            model="task.configuration.question"
            :label="trans_choice('Question|Questions', 1)"
            :setup_data="$task->configuration['question'] ?? []"
        />


        <div x-data="{
                size: {w: 0, h: 0, zoom: 1},
                dragging: {mouse_x: null, mouse_y: null},
                init(){
                    this.update_zoom();
                },
                update_zoom() {
                    this.size.w = this.$refs.base_image_preview.naturalWidth;
                    this.size.h = this.$refs.base_image_preview.naturalHeight;

                    this.size.real_w = this.$refs.base_image_preview.clientWidth;
                    this.size.real_h = this.$refs.base_image_preview.clientHeight;

                    const zoom_w = this.size.real_w / this.size.w;
                    const zoom_h = this.size.real_h / this.size.h;

                    this.size.zoom = Math.min(zoom_w, zoom_h);

                    console.log('[drag and drop] zoom = ', this.size.zoom)

                    if(!this.size.zoom || this.size.zoom === Infinity){
                        console.log('[drag and drop] zoom = ', this.size.zoom)
                        setTimeout(() => this.update_zoom(), 500);
                    }else{
                        this.size.zoom = Math.floor(this.size.zoom*100)/100;
                        console.log('[drag and drop] zoom = ', this.size.zoom)
                    }
                },
                drag_start(index, e){
                    this.dragging.mouse_x = e.offsetX;
                    this.dragging.mouse_y = e.offsetY;
                    e.dataTransfer.effectAllowed = 'move';
                },
                drag_end(index, e){
                    const offset_x = e.offsetX - this.dragging.mouse_x;
                    const offset_y = e.offsetY - this.dragging.mouse_y;

                    console.log('move', offset_x, offset_y);
                    this.$wire.call('move_tile_placeholder', index, offset_x, offset_y);
                }
             }"
             @resize.window="update_zoom"
             class="relative overflow-auto">

            <x-game-engine::livewire.image_field
                x-bind:style="size.zoom ? `width: ${size.w * size.zoom }px; height: ${size.h * size.zoom }px;` : ``"
                id="base_image"
                model="image_assets.base_image"
                :uploaded-url="$task->getFirstMediaUrl('base_image')"
                :helper="__('SVG, PNG or JPG')"
                remove-method="remove_base_image"
            />

            @foreach($task->tiles() as $tile_index => $tile_data)
                @php($uploading_image = $this->image_assets['tile_'.$tile_index] ?? null)

                @php($media = $task->media->find($tile_data['media_id']))

                @continue($media === null && empty($uploading_image?->getMimeType()))

                <img src="{{$media?->getUrl() ?? $uploading_image?->temporaryUrl()}}"
                     id="draggable_tile_{{$tile_index}}"
                     wire:key="draggable_tile_{{$tile_index}}"
                     class="cursor-pointer hover:opacity-90 origin-top-left"
                     :style="`position: absolute; top: ${ {{$tile_data['anchor']['y']}} * size.zoom}px; left: ${ {{$tile_data['anchor']['x']}} * size.zoom}px; scale: ${size.zoom};`"
                     draggable=true
                     @dragstart="drag_start({{$tile_index}}, event)"
                     @dragend="drag_end({{$tile_index}}, event)"
                >
            @endforeach
        </div>

    </div>

    @if(count($task->tiles()))

        <x-game-engine::elements.labeled-box :label="trans_choice('Tile|Tiles', 2)" class="space-y-4">
            @foreach($task->tiles() as $tile_index => $tile_data)
                <x-game-engine::elements.marked-box x-data="{show_awards: false}">
                    <div class="space-y-4 grow">
                        <div class="flex">
                            <x-game-engine::livewire.image_field
                                id="tile_placeholder_{{$tile_index}}"
                                model="image_assets.tile_{{$tile_index}}"
                                :label='$task->media->find($tile_data["media_id"]) || !empty($this->image_assets["tile_$tile_index"])? "" : __("Upload new tile image")'
                                :uploaded-url="$task->media->find($tile_data['media_id'])?->getUrl(MediaConversion::thumb->name)"
                                :helper="__('SVG, PNG or JPG')"
                                remove-method="remove_tile_placeholder({{$tile_index}})"
                                class="mr-2"
                            />

                            <div class="flex flex-row gap-16">
                                <x-number :label="trans_choice('Snap|Snaps', 1)" :w-full="false" size="sm" max="4" model="task.configuration.tiles.{{$tile_index}}.snap" base-class="w-16" defer>
                                    <x-slot name="postfix">{{__('px')}}</x-slot>
                                </x-number>

                                <x-checkbox class="mt-6" :label="__('Should not be placed')" model="task.configuration.tiles.{{$tile_index}}.should_not_be_placed" defer/>
                            </div>

                            @if($available_awards->isNotEmpty())
                                <x-button icon="star"
                                          color="secondary"
                                          size="sm"
                                          wire:loading.disable
                                          title="{{trans_choice('Award|Awards', 2)}}"
                                          @click="show_awards = !show_awards"
                                          class="my-auto ml-4"
                                />
                            @endif
                            <x-button icon="trash"
                                      class="my-auto ml-auto"
                                      size="sm"
                                      color="secondary"
                                      wire:click="delete_tile({{$tile_index}})"
                                      wire:loading.disable
                            />
                        </div>


                        <div class="ml-4 "  x-show="show_awards">
                            <x-tabs class="border rounded rounded-md p-2">
                                <x-slot name="correct" :label="__('Correct Placements Points')">
                                    <x-game-engine::awards.assign :awards="$available_awards" model="task.configuration.tiles.{{$tile_index}}.awards"/>
                                </x-slot>
                                <x-slot name="wrong" :label="__('Wrong Placements Points')">
                                    <x-game-engine::awards.assign :awards="$available_awards" model="task.configuration.tiles.{{$tile_index}}.failure_awards"/>
                                </x-slot>
                            </x-tabs>
                        </div>


                    </div>

                </x-game-engine::elements.marked-box>
            @endforeach
        </x-game-engine::elements.labeled-box>
    @endif

    <div class="flex flex-col gap-6">
        <x-button color="secondary"
                  size="sm"
                  icon="plus"
                  class="mr-auto"
                  wire:click="add_tile"
                  wire:loading.disable
        >{{__('Add Tile')}}</x-button>

        <div class="flex flex-col">
            <x-checkbox model="task.configuration.randomize_tiles_order" :label="__('Randomize tiles order')"/>
            <x-checkbox model="task.configuration.repositioning_allowed" :label="__('Allow tiles repositioning')"/>
            <x-checkbox model="task.configuration.partial_submit_allowed" :label="__('Allow answer submit if not finished')"/>
            <x-checkbox model="task.configuration.loose_snaps" :label="__('Allow tiles release outside snaps')"/>
        </div>
    </div>


    @if($available_awards->isNotEmpty())
        <x-card :collapsed="true">
            <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
                <x-icon name="star"/>&nbsp;{{__('100% Completion Awards')}}
            </x-slot>
            <x-tabs class="border rounded rounded-md p-2">
                <x-slot name="success" :label="__('Success')">
                    <x-game-engine::awards.assign :awards="$available_awards" model="task.configuration.completion_awards"/>
                </x-slot>
                <x-slot name="failure" :label="__('Failure')">
                    <x-game-engine::awards.assign :awards="$available_awards" model="task.configuration.failure_awards"/>
                </x-slot>
            </x-tabs>
        </x-card>
    @endif
</div>
