<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Storytellings;

use DefStudio\Actions\Action;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Storytellings\StorytellingAvatarImageUpdated;

/**
 * @method static void run(Storytelling $storytelling, UploadedFile $background_image_file)
 */
class StoreAvatarImage extends Action
{
    public function handle(Storytelling $storytelling, UploadedFile $avatar_image_file): void
    {
        Gate::authorize('update', $storytelling);

        $storytelling->addMedia($avatar_image_file)
            ->toMediaCollection(MediaCollection::avatar->name);

        StorytellingAvatarImageUpdated::dispatch($storytelling);
    }
}
