<?php

namespace DefStudio\GameEngine\Actions\Stories;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Events\Stories\StoryDeleted;
use DefStudio\GameEngine\Events\Stories\DeletingStory;

class DeleteStory extends Action
{
    public function handle(Story $story): void
    {
        Gate::authorize('delete', $story);

        DB::transaction(function() use ($story): void {
            DeletingStory::dispatch($story);

            $story->delete();

            StoryDeleted::dispatch($story);
        });

    }
}
