<?php

/** @noinspection PhpUnhandledExceptionInspection */

/** @noinspection LaravelUnknownEloquentFactoryInspection */

namespace DefStudio\GameEngine\Models;

use ArrayObject;
use Spatie\MediaLibrary\HasMedia;
use Illuminate\Database\Eloquent\Model;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Enums\StorytellingType;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Casts\AsArrayObject;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use DefStudio\GameEngine\Models\Contracts\WithStorytelling;
use DefStudio\GameEngine\Database\Factories\StorytellingFactory;

/**
 * @property ArrayObject<string, string> $text;
 * @property string $avatar_position;
 * @property StorytellingType $type;
 * @property-read WithStorytelling&Model $target
 *
 * @method static StorytellingFactory factory(array|callable|int|null $count = null, array|callable $state = [])
 */
class Storytelling extends Model implements HasMedia
{
    use HasFactory;
    use Concerns\HasMedia;

    protected $fillable = [
        'type',
        'text',
        'avatar_position',
    ];

    protected $casts = [
        'type' => StorytellingType::class,
        'text' => AsArrayObject::class,
    ];

    protected $attributes = [
        'avatar_position' => 'right',
    ];

    protected array $media_collections = [
        MediaCollection::background,
        MediaCollection::avatar,
    ];

    public function getTable()
    {
        return config('game-engine.storytelling.table', parent::getTable());
    }

    protected static function newFactory(): StorytellingFactory
    {
        return StorytellingFactory::new();
    }

    /**
     * @return MorphTo<Model, Storytelling>
     */
    public function target(): MorphTo
    {
        return $this->morphTo();
    }

    public function localized_text(): string
    {
        return localize($this->text);
    }
}
