@php
    use DefStudio\GameEngine\Models\Map;
    use DefStudio\GameEngine\Enums\MediaCollection;
    /** @var  Map $map */
@endphp

<x-card :header="__('Editor')">
    <script>
        document.addEventListener('alpine:init', () => Alpine.data('map_editor', () => ({
            fullscreen: false,
            dragging: {id: null, mouse_x: null, mouse_y: null},
            missions: @entangle('mission_placeholders'),
            size: {w: 0, h: 0},
            init() {
                this.$nextTick(() => {
                    this.size.w = this.$refs.background.naturalWidth;
                    this.size.h = this.$refs.background.naturalHeight;
                });
            },

            check_element_fits_in_background(x, y, w, h) {
                if (x < 0) {
                    return false;
                }

                if (y < 0) {
                    return false;
                }

                if (x + w > this.size.w) {
                    return false;
                }

                return y + h <= this.size.h;
            },
            mission_drag_start(mission, event) {
                this.dragging.id = mission.id;
                this.dragging.mouse_x = event.offsetX;
                this.dragging.mouse_y = event.offsetY;
                event.dataTransfer.effectAllowed = 'move';

            },
            mission_moved(mission, event) {
                const new_x = mission.pos_x + event.offsetX - this.dragging.mouse_x;
                const new_y = mission.pos_y + event.offsetY - this.dragging.mouse_y;


                if (!this.check_element_fits_in_background(new_x, new_y, event.target.offsetWidth, event.target.offsetHeight)) {
                    return;
                }

                mission.pos_x = new_x;
                mission.pos_y = new_y;
            },
        })));
    </script>
    <div x-data="{selected_mission: -1}">
        @if($this->background_image_url)
            <div x-data="map_editor" class="relative">

                <x-icon name="arrows-pointing-out" class="absolute top-2 right-2 z-10 cursor-pointer" @click="fullscreen = !fullscreen"
                        x-bind:style="fullscreen && 'position: fixed;'"
                />
                <div class="w-full relative overflow-auto" :style="fullscreen && 'z-index: 5; position: fixed; top:0; left:0; bottom:0; right:0'">
                    <div :style="{width: size.w+'px', height: size.h+'px'}">
                        <img src="{{$this->background_image_url}}" alt="{{__('Background image is missing')}}"
                             x-ref="background"
                        >
                    </div>

                    <template x-for="mission in missions" :key="mission.id">
                        <div class="cursor-pointer absolute box-border"
                             :style="{top: mission.pos_y+'px', left: mission.pos_x+'px'}"
                             :class="selected_mission == mission.id && 'brightness-150'"

                             x-on:mouseover="selected_mission = mission.id" x-on:mouseleave="selected_mission = -1"
                             @click="$wire.emit('openModal', 'game-engine.admin.missions.edit', {isModal: true, mission_id: mission.id})"

                             draggable="true"
                             @dragstart="mission_drag_start(mission, event)"
                             @dragend="mission_moved(mission, event)"
                        >
                            <template x-if="mission.placeholder_image">
                                <img :src="mission.placeholder_image" :alt="mission.id" class="w-auto h-auto max-w-none">
                            </template>
                        </div>
                    </template>
                </div>
            </div>

            <div class="mt-4" wire:sortable="update_missions_order">
                @foreach($map->missions->sortBy(['order', 'id']) as $mission)
                    <div x-on:mouseover="selected_mission = {{$mission->id}}"
                         x-on:mouseleave="selected_mission = -1"
                         class="flex min-w-[350px] cursor-move rounded-md bg-gray-100 shadow mt-2 px-2 py-1"
                         wire:sortable.handle
                         wire:sortable.item="{{$mission->id}}"
                         wire:key="mission-{{$mission->id}}">
                        <div class="my-auto flex">
                            <x-icon name="cursor-arrow-ripple" x-bind:class="selected_mission == {{$mission->id}} && 'text-red-500'"/>&nbsp;{{$mission->title}}
                        </div>
                        <x-button size="sm" color="secondary" class="ml-auto" icon="pencil"
                                  wire:click="$emit('openModal', 'game-engine.admin.missions.edit', {{json_encode(['isModal' => true, 'mission_id' => $mission->id])}})"
                        ></x-button>

                        <x-confirm-action class="ml-2" title="Warning"
                                          :content="__('Do you really want to delete this mission?')"
                                          :requires-password="true"
                                          wire:then="delete_mission({{$mission->id}})"
                        >
                            <x-button icon="trash" color="secondary" size="sm"/>
                        </x-confirm-action>
                    </div>
                @endforeach
            </div>


            @feature(\DefStudio\GameEngine\Enums\Feature::deadlines)
            <div class="mt-8 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4">
                <x-game-engine::elements.time-limit/>
            </div>
            @endfeature


            <x-slot name="actions">
                <x-button class="mr-auto" color="secondary" wire:click="add_mission" wire:loading.disable>{{__('Add Mission')}}</x-button>

                <x-button @class([
                    "opacity-0" => !$dirty,
                    "opacity-100" => $dirty,
                ]) color="secondary" wire:click="save" wire:loading.disable
                >{{__('Save')}}</x-button>


            </x-slot>
        @endif
    </div>
</x-card>
