<?php

namespace DefStudio\GameEngine\Actions\Storytellings;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Events\Storytellings\StorytellingDeleted;

/**
 * @method static Storytelling run(Storytelling $storytelling)
 */
class DeleteStorytelling extends Action
{
    public function handle(Storytelling $storytelling): Storytelling
    {
        Gate::authorize('delete', $storytelling);

        $storytelling->delete();

        StorytellingDeleted::dispatch($storytelling);

        return $storytelling;
    }
}
