<?php

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use DefStudio\GameEngine\Enums\MediaCollection;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Database\Factories\Concerns\DefinesAwards;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;

class MapFactory extends Factory
{
    use DefinesAwards;
    use HasMedia;
    use HasStorytelling;

    public function modelName(): string
    {
        return game_engine()->mapClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence(),
            'description' => fake()->text,
            'story_id' => game_engine()->storyClass()::factory(),
        ];
    }

    public function with_background_image(?string $path = null): MapFactory
    {
        return $this->with_media(MediaCollection::background, $path);
    }
}
