@php
    /** @var \DefStudio\GameEngine\Models\Team $team */
@endphp
<x-app-layout>
    <x-slot name="header">
        @isset($team)
            {{__('Edit Team :name', ['name' => $team->name])}}
        @else
            {{__('Create Team')}}
        @endisset
    </x-slot>

    <x-slot name="actions">
        <x-link class="ml-auto" :href="\game_engine()->back_url()" icon="arrow-sm-left" color="secondary" size="sm">{{__('Back')}}</x-link>
    </x-slot>

    @if(isset($team) ? \Illuminate\Support\Facades\Gate::check('update', $team) : \Illuminate\Support\Facades\Gate::check('create', \DefStudio\GameEngine\Models\Team::class))
        <x-container>
            <livewire:game-engine.admin.teams.edit :team="$team ?? \game_engine()->teamQuery()->make(['organization_id' => $organization->id])"/>
        </x-container>
    @endif

    @isset($team)
        <x-container class="mt-4">
            <x-card>
                <x-slot name="header" class="!bg-gray-200 font-bold uppercase">{{trans_choice('User|Users', 2)}}</x-slot>
                <livewire:game-engine.admin.teams.users.table :team="$team"/>
            </x-card>
        </x-container>

        <x-container>
            @feature(\DefStudio\GameEngine\Enums\Feature::team_stories)
            @can('update', $team)
                <x-card class="mt-4 subscribers-table">
                    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">{{trans_choice('Story|Stories', 2)}}</x-slot>
                    <livewire:game-engine.admin.teams.stories.table :subscriber="$team"/>
                </x-card>
            @endcan
            @endfeature
        </x-container>
    @endif
</x-app-layout>
