@php
    /** @var \DefStudio\GameEngine\Http\Livewire\Missions\Edit $this */
@endphp

<x-card :collapsed="$this->mission->tasks->isNotEmpty()">
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
        <x-icon name="check-badge"/>&nbsp;{{trans_choice('Task|Tasks', 2)}}
    </x-slot>

    <div class="space-y-6">
        <div class="flex justify-between items-center">
            <div class="flex items-center">
                <span>{{__('Max tasks to show')}}</span>
                <x-number class="ml-2" size="sm" model="configuration.max_tasks_to_show" defer/>
            </div>
            <x-checkbox :label="__('Randomize tasks order')" model="configuration.randomize_tasks_order" defer/>
        </div>

        <div wire:sortable="update_tasks_order">
            @foreach($this->mission->tasks->sortBy(['order', 'id']) as $task)

                <x-game-engine::elements.marked-box class="mt-2 cursor-move"
                                                    wire:sortable.handle
                                                    wire:sortable.item="{{$task->id}}"
                                                    wire:key="task-{{$task->id}}"
                >
                    <div class="my-auto">{{$task->title}}</div>
                    <div class="my-auto ml-auto text-gray-600">({{$task::type_label()}})</div>
                    <div>
                        <x-button class="ml-4" size="sm" color="secondary" icon="pencil"
                                  wire:click="$emit('openModal', 'game-engine.admin.tasks.edit', {{json_encode(['isModal' => true, 'task_id' => $task->id])}})"
                        />
                        <x-confirm-action class="ml-auto" title="Warning"
                                          :content="__('Do you really want to delete this task?')"
                                          :requires-password="true"
                                          wire:then="delete_task({{$task->id}})"
                        >
                            <x-button icon="trash" color="secondary" size="sm"/>
                        </x-confirm-action>
                    </div>
                </x-game-engine::elements.marked-box>

            @endforeach
        </div>

        <div class="flex">
            <x-button class="ml-auto" color="secondary"
                      wire:click="$emit('openModal', 'game-engine.admin.tasks.edit', {{json_encode(['isModal' => true, 'mission_id' => $this->mission->id])}})"
                      :disabled="$this->mission->should_complete_on_activation()"
            >
                {{__('Create Task')}}
            </x-button>
        </div>
    </div>


</x-card>
