<?php

/** @noinspection PhpDocSignatureIsNotCompleteInspection */

namespace DefStudio\GameEngine\Actions\Missions\Contracts;

use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Decorators\Runs\PlayableMission;

interface TaskExtractor
{
    /**
     * @return Collection<int, Task>
     */
    public function extract(PlayableMission $mission): Collection;

    /**
     * @return array<array-key, array{label: string, tags: array<array-key, string>}>
     */
    public function task_tags(): array;
}
