<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Symfony\Component\HttpFoundation\Response;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

use function game_engine;

class OrganizationsController
{
    use AuthorizesRequests;

    public function index()
    {
        $this->authorize('viewAny', game_engine()->organizationClass());

        return view('game-engine::admin.organizations.index');
    }

    public function create()
    {
        $this->authorize('create', game_engine()->organizationClass());

        return view('game-engine::admin.organizations.edit');
    }

    public function edit(int $organization)
    {
        $organization = game_engine()->organizationQuery()->findOrFail($organization);
        $this->authorize('update', $organization);

        return view('game-engine::admin.organizations.edit', ['organization' => $organization]);
    }

    public function current()
    {
        abort_if(game_engine()->user()->current_organization_id === null, Response::HTTP_FORBIDDEN);

        return $this->edit(game_engine()->user()->current_organization_id);
    }

    public function switch(int $organization)
    {
        $organization = game_engine()->organizationQuery()->findOrFail($organization);

        game_engine()->user()->switch_organization($organization);

        return redirect()->back()->with('switched_organization', true);
    }

    public function register()
    {
        return view('game-engine::admin.organizations.register');
    }
}
