@props(['awards', 'model'])

@php
    use DefStudio\GameEngine\Models\Award;
    use Illuminate\Database\Eloquent\Collection;

    /** @var Collection<int, Award> $awards */
@endphp

<div {{$attributes->class('space-y-4')}}>
    @foreach($awards->loadMissing(['children']) as $award)
        <div class="flex gap-3">
            <div class="w-32">
                <x-number size="sm" :label="$award->name" model="{{$model}}.{{$award->id}}" step="0.01" defer/>
            </div>

            @if($award->children->isNotEmpty())
                <div class="mt-6">+</div>
            @endif

            @foreach($award->children->sortBy('order') as $child_award)
                <div class="w-32">
                    <x-number size="sm" :label="$child_award->name" model="{{$model}}.{{$child_award->id}}" step="0.01" defer/>
                </div>
            @endforeach
        </div>
    @endforeach

</div>
