<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Http\Testing\File;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Missions\MissionPlaceholderImageCompletedUpdated;

/**
 * @method static void run(Mission $mission, UploadedFile $placeholder_image_file)
 */
class StorePlaceholderImageCompleted extends Action
{
    public function handle(Mission $mission, UploadedFile $placeholder_image_file): void
    {
        Gate::authorize('update', $mission);

        $mission->addMedia($placeholder_image_file)
            ->toMediaCollection(MediaCollection::placeholder_complete->name);

        MissionPlaceholderImageCompletedUpdated::dispatch($mission);
    }
}
