<?php

namespace DefStudio\GameEngine\Enums;

enum Permission: string
{
    case view_users = 'view.users';
    case create_users = 'create.users';
    case edit_users = 'edit.users';
    case delete_users = 'delete.users';
    case impersonate_users = 'impersonate.users';

    case view_teams = 'view.teams';
    case create_teams = 'create.teams';
    case edit_teams = 'edit.teams';
    case delete_teams = 'delete.teams';

    case view_organizations = 'view.organizations';
    case create_organizations = 'create.organizations';
    case edit_organizations = 'edit.organizations';
    case delete_organizations = 'delete.organizations';

    case view_stories = 'view_stories';
    case create_stories = 'create_stories';
    case edit_stories = 'edit_stories';
    case delete_stories = 'delete_stories';

    case manage_awards = 'manage_awards';

    public function for_role(Role|null $role): string
    {
        return $this->value.'.'.($role?->value ?? 'guest');
    }
}
