# Game Engine Core

## Installation

You can install the package via composer:

First add the private repository to composer.json:

```json
{
    //..

    "repositories": [
        {
            "type": "composer",
            "url": "https://packagist.defstudio.dev"
        }
    ]
}
```

then require the package, entering the private repository credentials

```bash
composer require defstudio/game-engine
```

1. setup jetstream/breeze
2. setup spatie/permissions

```bash
php artisan vendor:publish --provider="Spatie\Permission\PermissionServiceProvider"
```

3. setup barryvdh/translations

```bash
php artisan vendor:publish --provider="Barryvdh\TranslationManager\ManagerServiceProvider" --tag=config
php artisan vendor:publish --provider="Barryvdh\TranslationManager\ManagerServiceProvider" --tag=migrations
```

4. publish the config file with:

```bash
php artisan vendor:publish --tag="game-engine-config"
```


5. update `database/seeders/DatabaseSeeder` to include roles update command

```php
class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        Artisan::call('game-engine:sync-roles');
    }
}
```


6. publish and run the migrations with:

```bash
php artisan vendor:publish --tag="game-engine-migrations"
php artisan migrate --seed
``` 


7.  publish assets using

```bash
php artisan vendor:publish --tag="game-engine-assets" --force
```

and cofigure composer.json for updating assets after running `composer update` command:

```json
 "scripts": {
        "post-autoload-dump": [
           ...
        ],
        "post-update-cmd": [
            ...
            "@php artisan vendor:publish --tag=game-engine-assets --ansi --force"
        ],
  ...
```

finally, add a script component at the end of your main layout view:

```html
<x-game-engine::scripts/>

```




Optionally, you can publish the views using

```bash
php artisan vendor:publish --tag="game-engine-views"
```

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [Fabio Ivona](https://github.com/fabio-ivona)
- [All Contributors](../../contributors)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
