<x-app-layout>
    <x-slot name="header">
        @isset($user)
            {{__('Edit User :name', ['name' => $user->name])}}
        @else
                {{__('Create User')}}
        @endisset
    </x-slot>

    <x-slot name="actions">
        <x-link class="ml-auto" :href="game_engine()->back_url()" icon="arrow-sm-left" color="secondary" size="sm">{{__('Back')}}</x-link>
    </x-slot>

    <x-container>
        <livewire:game-engine.admin.users.edit :user="$user ?? \game_engine()->userQuery()->make()"/>
    </x-container>

    @isset($user)
        @feature(\DefStudio\GameEngine\Enums\Feature::user_stories)
        <x-container class="mt-4">
            <x-card>
                <x-slot name="header" class="!bg-gray-200 font-bold uppercase">{{trans_choice('Story|Stories', 2)}}</x-slot>
                <livewire:game-engine.admin.users.stories.table :subscriber="$user"/>
            </x-card>
        </x-container>
        @endfeature
    @endisset
</x-app-layout>
