<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Awards;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Award;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Awards\AwardIconImageUpdated;

/**
 * @method static void run(Award $award)
 */
class RemoveIconImage extends Action
{
    public function handle(Award $award): void
    {
        Gate::authorize('update', $award);

        $award->getFirstMedia(MediaCollection::icon)?->delete();
        $award->unsetRelation('media');

        AwardIconImageUpdated::dispatch($award);
    }
}
