@php
    use DefStudio\GameEngine\Enums\Permission;
@endphp

@can(Permission::debug_runs->name)
    @php($levels = $this->story->get_state('levels', []))
    @php($story_awards = $this->story->get_state('result.awards', []))
    @dump($levels)
    @if($story_awards !== [] || $levels !== [])
        <div class="fixed bottom-4 left-4 z-50 bg-gray-800 opacity-80 text-gray-200 text-sm px-2 py-1 rounded rounded-md">
            @if($story_awards !== [] || $levels !== [])
                <div><u>{{__('Level')}}</u></div>
                @foreach($levels as $level_name => $level)
                    <div>{{$level_name === 'default' ? __('Level') : $level_name}} {{$level}}</div>
                @endforeach
            @endif

            @if($story_awards !== [])
                <div class="mt-2"><u>{{__('Awards')}}</u></div>
                @foreach($story_awards as $award_id => $awarded_quantity)
                    <div>{{\DefStudio\GameEngine\Models\Award::findOrFail($award_id)->name}}: {{$awarded_quantity}}</div>
                @endforeach
            @endif
        </div>
    @endif


    <div class="fixed top-4 right-4 z-50">
        <x-button color="danger" wire:click="reset_run" wire:loading.disable>{{__('Reset Run')}}</x-button>
    </div>
@endcan
