<?php /** @var \DefStudio\GameEngine\Models\Organization $model */ ?>

<div class="flex">
    @can('update', $model)
        <x-link icon="pencil" color="secondary" size="sm" :href="route('game-engine.admin.organizations.edit', ['organization' => $model])"/>
    @endcan
    @can('delete', $model)
        <x-confirm-action class="ml-auto" title="Warning"
                          :content="__('Do you really want to delete this organization?')"
                          :requires-password="true"
                          wire:then="delete({{$model->id}})"
        >
            <x-button icon="trash" color="secondary" size="sm"/>
        </x-confirm-action>
    @endcan
</div>
