<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpMissingParamTypeInspection */

/** @noinspection PhpMissingFieldTypeInspection */

namespace DefStudio\GameEngine\Decorators;

use ArrayAccess;
use Illuminate\Database\Eloquent\Model;

/**
 * @template TModel of Model|ModelDecorator
 *
 * @mixin TModel
 */
abstract class ModelDecorator implements ArrayAccess
{
    /** @var TModel */
    protected $model;

    /**
     * @param  TModel|ModelDecorator<TModel>  $model
     */
    final public function __construct($model)
    {
        $this->model = $model instanceof static ? $model->model : $model;
        $this->setup_decorator();
    }

    /**
     * @param  TModel|ModelDecorator<TModel>  $model
     */
    final public static function build($model): static
    {
        return new static($model);
    }

    protected function setup_decorator(): void
    {
        // nothing by default...
    }

    public function __call(string $name, array $arguments): mixed
    {
        return $this->model->{$name}(...$arguments);
    }

    public function __set(string $name, mixed $value): void
    {
        $this->model->{$name} = $value;
    }

    public function __get(string $name): mixed
    {
        return $this->model->{$name};
    }

    public function offsetExists($offset): bool
    {
        return $this->model->offsetExists($offset);
    }

    public function offsetGet($offset): mixed
    {
        return $this->model->offsetGet($offset);
    }

    public function offsetSet($offset, $value): void
    {
        $this->model->offsetSet($offset, $value);
    }

    public function offsetUnset($offset): void
    {
        $this->model->offsetUnset($offset);
    }

    /**
     * @return TModel
     */
    public function model()
    {
        if($this->model instanceof ModelDecorator){
            return $this->model->model();
        }

        return $this->model;
    }
}
