@php
    use DefStudio\GameEngine\Models\Run;
    use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
    use DefStudio\GameEngine\Enums\StorytellingType;
    use DefStudio\GameEngine\Enums\Role;

    /** @var Runner $this */
    /** @var Run $run */
@endphp


<div wire:init="start">

    @if(game_engine()->role(Role::super_admin))
        @php($story_awards = $this->story->get_state('result.awards', []))
        @php($map_awards = $this->is_map_active() ? $this->map->get_state('result.awards', []) : [])
        @if($story_awards !== [])
            <div class="fixed bottom-4 left-4 z-50 bg-gray-800 opacity-80 text-gray-200 text-sm px-2 py-1 rounded rounded-md">
                <div><u>{{__('Story Awards')}}</u></div>
                @foreach($story_awards as $award_id => $awarded_quantity)
                    <div>{{\DefStudio\GameEngine\Models\Award::findOrFail($award_id)->name}}: {{$awarded_quantity}}</div>
                @endforeach

                @if($map_awards && $map_awards !== $story_awards)
                    <div class="mt-4"><u>{{__('Map Awards')}}</u></div>
                    @foreach($map_awards as $award_id => $awarded_quantity)
                        <div>{{\DefStudio\GameEngine\Models\Award::findOrFail($award_id)->name}}: {{$awarded_quantity}}</div>
                    @endforeach
                @endif
            </div>
        @endif
        <div class="fixed top-4 right-4 z-50">
            <x-button color="danger" wire:click="reset_run" wire:loading.disable>{{__('Reset Run')}}</x-button>
        </div>
    @endif

    @if($this->run->get_state('map.index', -1) >= 0)
        <x-game-engine::runs.map.main/>
    @endif
</div>
