<?php

namespace DefStudio\GameEngine\Http\Livewire\Concerns;

use DefStudio\GameEngine\Enums\TimeUnit;

trait ManagesTimeLimit
{
    /** @var int */
    public $time_limit;

    public string $time_limit_unit;

    abstract protected function time_limit_field(): string;

    public function mountManagesTimeLimit(): void
    {
        $this->time_limit = $this->getPropertyValue($this->time_limit_field()) ?? '';
        $this->time_limit_unit = $this->getPropertyValue($this->time_limit_field().'_unit') ?? TimeUnit::minutes->value;
    }

    public function store_time_limit(): void
    {
        $this->fill([
            $this->time_limit_field() => empty($this->time_limit) ? null : $this->time_limit,
            $this->time_limit_field() . '_unit' => empty($this->time_limit_unit) ? null : $this->time_limit_unit,
        ]);
    }
}